package coreservlets.listeners;

import javax.servlet.*;

/** Proces nasuchujcy, ktry monitoruje zmiany nazw
 *  towarw bdcych ofert dnia (przechowywanych w atrybucie
 *  daily-special-item-names kontekstu serwletu).
 *  Jeeli nazwy si zmieni, proces zresetuje aktualn
 *  warto licznika zamwie zoonych na towary
 *  z oferty dnia.
 *  <P>
 *  Taken from Core Servlets and JavaServer Pages Volume II
 *  from Prentice Hall and Sun Microsystems Press,
 *  http://volume2.coreservlets.com/.
 *  (C) 2007 Marty Hall, Larry Brown, and Yaakov Chaikin;
 *  may be freely used or adapted.
 */
public class ChangedDailySpecialListener
    implements ServletContextAttributeListener {

  /** Gdy oferta dnia si zmieni,
   *  warto licznika zostaje wyzerowana.
   */
  public void attributeReplaced
                   (ServletContextAttributeEvent event) {
    if (event.getName().equals("daily-special-item-names")) {
      ServletContext context = event.getServletContext();
      context.setAttribute("dailySpecialCount",
                           new Integer(0));
      DailySpecialWatcher.resetDailySpecialCount();
    }
  }

  public void attributeAdded
                   (ServletContextAttributeEvent event) {}
  
  public void attributeRemoved
                   (ServletContextAttributeEvent event) {}
}
